/**
* \file: errmem_socket_interface.h
*
* Definition of socket protocol.
* 
* Definition of the messages and message types for socket communication
* with the error memory daemon (or error memory backend)
*
* \component: errmemd
*
* \author: Markus Kretschmann (mkretschmann@de.adit-jv.com)
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
* <history item>
*/
#ifndef ERRMEM_SOCKET_INTERFACE_H
#define ERRMEM_SOCKET_INTERFACE_H

/* internal server states */
#define ERRMEM_SESSION_ESTABLISHED          1
#define ERRMEM_SESSION_READ_PERSISTENT     10
#define ERRMEM_SESSION_READING_PERSISTENT  11
#define ERRMEM_SESSION_READ                20
#define ERRMEM_SESSION_READING             21
#define ERRMEM_SESSION_READ_DONE           30
#define ERRMEM_SESSION_BACKEND_ERASED      31

/* status codes for internal use */
#define ERR_OK                              0x0
#define ERR_READ_END                        0x1
#define ERR_SESSION_BACKEND_ERASED          0x2
#define ERR_BLOCK_END                       0x4
#define ERR_STOPPED                         0x8
#define ERR_READ_CONTINUE                   0x10

#define ERR_BLOCK_CORRUPTED                 0x100
#define ERR_BLOCK_ERASED                    0x200

enum msg_type
{
	MSG_REQUEST_UNKNOWN      = 0,
	MSG_REQUEST_ESTABLISH,
	MSG_REQUEST_READ,
	MSG_REQUEST_SET_STORAGE,
	MSG_REQUEST_ERASE,
	MSG_REQUEST_STOP,
	MSG_REQUEST_DUMP,
	MSG_REQUEST_OUT_DEV
};

struct __attribute__ ((__packed__)) msg_header
{
	enum msg_type type;
	int32_t       status;
	size_t        len;
};


#endif
